IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CPJ_Cbtes_Rem_Fin') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE CPJ_Cbtes_Rem_Fin 
END
GO

CREATE PROCEDURE dbo.CPJ_Cbtes_Rem_Fin @pJson VARCHAR(8000)
AS 
SET NOCOUNT ON 

/*Variables recibidas por parametro a traves del JSON*/
DECLARE @pFlagUsarTrans		     	TINYINT
DECLARE @pModoDebug			    	TINYINT
DECLARE @pId_Trans				    INT
DECLARE @pObservacion_Incluye_Integ VARCHAR(8000)
DECLARE @pFlag_Tabla_Temp           TINYINT


SET @pFlagUsarTrans				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'FlagUsarTrans')), 0)
SET @pModoDebug					= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
SET @pId_Trans					= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Trans')), 0)
SET @pObservacion_Incluye_Integ = ISNULL(CONVERT(varchar(8000), dbo.CF_JSON_VALUE(@pObservacion_Incluye_Integ,'Observacion_Incluye_Integ')), '')
SET @pFlag_Tabla_Temp           = ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pFlag_Tabla_Temp,'Flag_Tabla_Temp')), 0)

/*FIN Variables recibidas por parametro a traves del JSON*/

/*Variable de Retorno del Stored*/
DECLARE @rtaErrorStored						INT
DECLARE @rtaMsjStored						VARCHAR(4000)
DECLARE @Result_Stored_Invocado				INT
DECLARE @JSON_Parametros_Stored_Invocado	VARCHAR(8000)
/*FIN Variable de Retorono del Stored*/

/*Declaracion Variables Locales*/
DECLARE @Id_Cta_Contable					INT
DECLARE @Fecha								DATETIME
DECLARE @Observacion						VARCHAR(100)
DECLARE @Item								SMALLINT

DECLARE @Descripcion_Cbte					VARCHAR(80)
DECLARE @Imp_Gravado_Sum_It					DECIMAL(12,2)
DECLARE @Porc_Bonificacion_Cb				DECIMAL(5,2)
DECLARE @Imp_Gravado						DECIMAL(12,2)
DECLARE @Imp_Iva_Sum_It						DECIMAL(12,2)
DECLARE @Imp_Iva							DECIMAL(12,2)
DECLARE @Imp_Exento							DECIMAL(12,2)
DECLARE @Imp_Total							DECIMAL(12,2)
DECLARE @Saldo								DECIMAL(12,2)
DECLARE @Imp_Bonificacion					DECIMAL(12,2)
DECLARE @Cantidad							DECIMAL(12,4)
/*Fin de Declaraciones Variables Locales */


BEGIN TRY

	IF @pFlagUsarTrans <> 0 
	BEGIN
		BEGIN TRAN
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Ingreso a Stored Procedure: CPJ_Cbtes_Rem_Fin'
		PRINT 'Parametros:'
		PRINT 'FlagUsarTrans: ' + CONVERT(VARCHAR(10), @pFlagUsarTrans) + ' Id_Trans: ' + CONVERT(VARCHAR(10), @pId_Trans)
	END
	
	/*===================================================================*/

	IF(@pId_Trans = 0)
	BEGIN
		SET @rtaErrorStored = 70001 /*Transaccion no abierta*/
		
		SELECT	 @rtaErrorStored	AS ErrorNumber 
				,0					AS ErrorSeverity  
				,0					AS ErrorState 
				,0					AS ErrorProcedure  
				,0					AS ErrorLine		
				,''					AS ErrorMessage
			
		IF @pFlagUsarTrans <> 0 
		BEGIN
			ROLLBACK
		END
		
		RETURN 9999
	END
	
	/*===================================================================*/	
		
	SET @JSON_Parametros_Stored_Invocado =	'{' +
											dbo.CF_Json_ParsearVariable('Id_Trans', @pId_Trans, 'INT') +
											'}'
											
	
	/*===================================================================*/
	
	SET @Descripcion_Cbte = (dbo.CF_Cbte_Descrip(@pId_Trans))
	
	/*===================================================================*/	
	
	UPDATE Transacciones SET Descripcion = @Descripcion_Cbte WHERE Id_Trans = @pId_Trans
	
	/*===================================================================*/	
	
	UPDATE Cbtes_Items 	SET Id_Estado_Cbte = 1	WHERE Id_Trans = @pId_Trans
	
	/*===================================================================*/
		
	SET @Porc_Bonificacion_Cb	= ISNULL((SELECT ISNULL(Porc_Bonificacion, 0) FROM Cbtes WHERE Id_Trans = @pId_Trans), 0)
	
	IF @pFlag_Tabla_Temp = 0
	   BEGIN
        	SET @Imp_Gravado_Sum_It		= ISNULL((SELECT SUM((ISNULL(Imp_Gravado, 0) * ISNULL(Cantidad_Saldo, 0))) FROM Cbtes_Items WHERE Id_Trans = @pId_Trans), 0)
        	SET @Imp_Iva_Sum_It			= ISNULL((SELECT SUM(ISNULL(Imp_Iva, 0)) FROM Cbtes_Items WHERE Id_Trans = @pId_Trans), 0)
 	        SET @Imp_Exento				= ISNULL((SELECT SUM((ISNULL(Imp_Exento, 0) * ISNULL(Cantidad_Saldo, 0))) FROM Cbtes_Items WHERE Id_Trans = @pId_Trans), 0)
        	SET @Cantidad				= ISNULL((SELECT COUNT(*) FROM Cbtes_Items WHERE Id_Trans = @pId_Trans), 0)  
       END
      ELSE
	   BEGIN
        	SET @Imp_Gravado_Sum_It		= ISNULL((SELECT SUM((ISNULL(Imp_Gravado, 0) * ISNULL(Cantidad_Saldo, 0))) FROM #ITEMS_CBTE), 0)
        	SET @Imp_Iva_Sum_It			= ISNULL((SELECT SUM(ISNULL(Imp_Iva, 0)) FROM #ITEMS_CBTE), 0)
 	        SET @Imp_Exento				= ISNULL((SELECT SUM((ISNULL(Imp_Exento, 0) * ISNULL(Cantidad_Saldo, 0))) FROM #ITEMS_CBTE), 0)
        	SET @Cantidad				= ISNULL((SELECT COUNT(*) FROM #ITEMS_CBTE), 0)  
       END        	
        	    	
	IF(@Porc_Bonificacion_Cb = 0)
		SET @Imp_Gravado		= @Imp_Gravado_Sum_It
	  ELSE
		SET @Imp_Gravado		= (@Imp_Gravado_Sum_It * ((100 - @Porc_Bonificacion_Cb) / 100))


	SET @Imp_Iva				= @Imp_Iva_Sum_It
	SET @Imp_Total				= @Imp_Gravado + @Imp_Iva + @Imp_Exento
	SET @Saldo					= @Imp_Total
	SET @Imp_Bonificacion		= (@Imp_Gravado_Sum_It - @Imp_Gravado)		


	
	/*===================================================================*/	
	IF @Imp_Iva = 0
	   BEGIN
	     SET @Imp_Exento = @Imp_Exento+@Imp_Gravado
		 SET @Imp_Gravado = 0
       END
	
	UPDATE Cbtes 
	SET 
	Cantidad			= @Cantidad,
	Imp_Gravado			= @Imp_Gravado, 
	Imp_Exento			= @Imp_Exento,
	Saldo				= @Saldo, 
	Imp_Iva				= @Imp_Iva,
	Imp_Bonificacion	= @Imp_Bonificacion,
	Imp_Total			= @Imp_Total,
	Observacion         = @pObservacion_Incluye_Integ 
	WHERE 
	Id_Trans = @pId_Trans

	/*===================================================================*/	


	SET @JSON_Parametros_Stored_Invocado =	'{' +
											dbo.CF_Json_ParsearVariable('FlagUsarTrans', 0, 'INT') + ',' +
											dbo.CF_Json_ParsearVariable('Id_Trans', @pId_Trans, 'INT') + ',' +
											dbo.CF_Json_ParsearVariable('ModoDebug', @pModoDebug, 'INT') + ',' +
											dbo.CF_Json_ParsearVariable('FlagRegenerar', 1, 'TINYINT') + 
											'}'
						
	EXEC @Result_Stored_Invocado = dbo.CPJ_Cbtes_Ctas_Contables_Generar @JSON_Parametros_Stored_Invocado
	IF ISNULL(@Result_Stored_Invocado,0) <> 0 
	BEGIN
		/*El CPJ_Cbtes_Ctas_Contables_Generar deberia devolver el SELECT con el error*/
		RETURN 9999
	END		



	EXEC @Result_Stored_Invocado = dbo.CPJ_Cbtes_Grabar_Numero @JSON_Parametros_Stored_Invocado
	IF ISNULL(@Result_Stored_Invocado,0) <> 0 
	BEGIN
		/*El CPJ_Cbtes_Grabar_Numero deberia devolver el SELECT con el error*/
		RETURN 9999
	END

	--17/11/2020 Se agrega que si el saldo es 0 en cta cte tiene que poner el estado en completo
	IF(@Saldo = 0)
	BEGIN
		UPDATE Clientes_CtaCte
		SET
		Id_Estado_Cbte = 2 --Completo
		WHERE
		Id_Trans = @pId_Trans
	END

	/*===================================================================*/	
	
	IF @pFlagUsarTrans <> 0 
	BEGIN
		COMMIT
	END

	/*===================================================================*/	

	SET @rtaMsjStored		=	'{' +
								dbo.CF_Json_ParsearVariable('id_trans', @pId_Trans, 'INT') + ',' +
								dbo.CF_Json_ParsearVariable('descrip_Cbte', @Descripcion_Cbte, 'VARCHAR') +
								'}'

	SELECT	 0				AS ErrorNumber 
			,0				AS ErrorSeverity  
			,0				AS ErrorState 
			,0				AS ErrorProcedure  
			,0				AS ErrorLine		
			,@rtaMsjStored	AS ErrorMessage

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Fin Stored Procedure: CPJ_Cbtes_Rem_Fin'
	END

END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo

	IF @pFlagUsarTrans <> 0 
	BEGIN
		ROLLBACK
	END

	RETURN 9999
END CATCH

RETURN 0 